﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Private ballPoints As New PointCollection()
    Private isForward As Boolean = True

    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property EasingFunction() As EasingFunctionBase


    Private Sub OnMainPageLoaded(ByVal sender As Object,
                                 ByVal args As RoutedEventArgs) Handles Me.Loaded
        Dim left = 100.0
        Dim right = ContentPanel.ActualWidth - 100
        Dim center = ContentPanel.ActualWidth / 2
        Dim top = 100.0
        Dim bottom = ContentPanel.ActualHeight - 100

        polyline1.Points.Add(New Point(left, top))
        polyline1.Points.Add(New Point(right, top))

        polyline2.Points.Add(New Point(left, bottom))
        polyline2.Points.Add(New Point(right, bottom))

        ballPoints.Add(New Point(center, top))
        ballPoints.Add(New Point(center, bottom))

        ballGeometry.Center = ballPoints(1 - Convert.ToInt32(isForward))
    End Sub


    Private Sub OnAppbarPlayButtonClick(ByVal sender As Object, ByVal args As EventArgs)
        pointAnimation.From = ballPoints(1 - Convert.ToInt32(isForward))
        pointAnimation.To = ballPoints(Convert.ToInt32(isForward))
        pointAnimation.EasingFunction = EasingFunction

        storyboard.Begin()
    End Sub


    Private Sub OnStoryboardCompleted(ByVal sender As Object, ByVal args As EventArgs)
        isForward = isForward Xor True
    End Sub


    Private Sub OnAppbarSettingsButtonClick(ByVal sender As Object, ByVal args As EventArgs)
        NavigationService.Navigate(New Uri("/EasingFunctionDialog.xaml", UriKind.Relative))
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        If TypeOf args.Content Is EasingFunctionDialog Then
            TryCast(args.Content, EasingFunctionDialog).EasingFunction = EasingFunction
        End If
        MyBase.OnNavigatedTo(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        ApplicationTitle.Text = "THE EASING LIFE - " &
            (If(EasingFunction IsNot Nothing, EasingFunction.GetType().Name, "none"))

        MyBase.OnNavigatedTo(args)
    End Sub
End Class
